C ----------------------------------------------------------------------
C
C Fr  Programme Kendall_W: 
C     Test de concordance (W de Kendall) entre plusieurs juges.
C     Note: W est en relation lineaire avec la moyenne des r de Spearman entre
C           toutes les paires de 'juges' (matrices). Siegel (1956: 232).
C     
C     Principe du test:
C     1. Lire les donnees provenant des differents juges et les ecrire dans
C        les lignes d'un tableau sous forme depliee.
C     2. Transformer les valeurs de chaque juge en rangs.
C     3. Calculer le coefficient de concordance W de Kendall.
C     4. Permuter chaque juge et calculer W*.
C     5. Repeter l'etape 4 un grand nombre de fois.
C     6. Ajouter W a la distribution des W*, puis calculer la 
C        probabilite permutationnelle.
C
C Eng Program Kendall_W: This program computes a test of the concordance 
C     (Kendall W test) among several judges, using permutations.
C
C ----------------------------------------------------------------------
C
C     nmax = nombre maximum d'objets (n = nombre reel d'objets)
C     jugemax = n. max. de juges (m = n. reel de juges)
C     kmax = longueur maximum d'une demi-matrice depliee (k = longueur reelle)
C
C     Mat = matrice (juges x objets). Donnees brutes puis donnees en rangs
C     Table = matrice (juges x objets). Donnees modifiees en cours de calcul
C
C     Ce programme teste la statistique "smrsq" par permutation.
C
C                                            Pierre Legendre, 2000, 2004
C
C ----------------------------------------------------------------------
C2345678901234567890123456789012345678901234567890123456789012345678901234567890
      Parameter (nmax=2000,jugemax=1000)
      Integer iordre(nmax),liste(nmax),novar(jugemax),number(jugemax)
      Real*8 Mat(jugemax,nmax),Table(jugemax,nmax),R(nmax),
     +       data(nmax),rang(nmax),SpearR(jugemax,jugemax),
     +       vec(jugemax),Result(jugemax,7),buffer(jugemax)
C
C BBEdit is the 'creator' for output files
C      call F_Creator('R*ch')
C Langue du dialogue / Dialog language: 1 = francais; 2 = English
    2 write(*,*) 'Francais: tapez (1)'
      write(*,*) 'English:  type  (2)'
      read(*,*) langue
      if((langue.lt.1).or.(langue.gt.2)) goto 2
      open(7,file='Concord.out',status='NEW')
      if(langue.eq.1) then
         write(*,106)
         write(7,106)
         write(*,109) jugemax,nmax
         else
         write(*,206)
         write(7,206)
         write(*,209) jugemax,nmax
         endif
C Lecture des donnees, etc.
      call Lecture(n,m,k,Mat,Table,nmax,jugemax,langue)
C      write(*,*)
C      write(*,*)'Informations additionnelles (debug)? (0) non (1,2) oui'
C      read(*,*) idebug
      idebug=0
    4 if(langue.eq.1) then
         write(*,102)
         else
         write(*,202)
         endif
      read(*,*) ities
      if((ities.lt.1).or.(ities.gt.2)) goto 4
      write(*,*)
      if(langue.eq.1) write(*,*) 'Combien de permutations? ',
     +   '(e.g., 999, 9999, ...)'
      if(langue.eq.2) write(*,*) 'How many permutations? ',
     +   '(e.g., 999, 9999, ...)'
      read(*,*) nperm
      write(*,*)
      if(langue.eq.1) then
         write(7,108) nperm
         else
         write(7,208) nperm
         endif
C Demarrer l'horloge
C      debut=secnds(0.0)
      call Concord(n,m,k,Mat,Table,R,nmax,jugemax,langue,nperm,
     +  iordre,liste,data,rang,SpearR,vec,Result,buffer,number,novar,
     +  ities,idebug)
C Duree du calcul
      write(*,*)
C      fin=secnds(debut)
      if(langue.eq.1) then
C         write(*,110) fin
         write(*,*) 
     +   "Les resultats se trouvent dans le fichier 'Concord.out'"
         write(*,*) 'Fin du programme.'
         else
C         write(*,210) fin
         write(*,*) "Results are found in file 'Concord.out'"
         write(*,*) 'End of the program.'
         endif
      close(7)
      stop
  102 format(/' Test (1) avec ou (2) sans correction',
     +        ' pour valeurs liees?')
  202 format(/' Test (1) with or (2) without correction for ties?')
  106 format(/' Test de concordance de Kendall'//
     +       ' Pierre Legendre'/
     +       ' Departement de sciences biologiques'/
     +       ' Universite de Montreal.'/
     +       '       (c) Pierre Legendre, 2000, 2004'/)
  206 format(/' Kendall''s test of concordance'//
     +       ' Pierre Legendre'/
     +       ' Departement de sciences biologiques'/
     +       ' Universite de Montreal.'/
     +       '       (c) Pierre Legendre, 2000, 2004'/)
  107 format(' * = parametre significatif au seuil 0.05')
  207 format(' * = parameter significant at 0.05 level')
  108 format(' Nombre de permutations:',i6/)
  208 format(' Number of permutations:',i6/)
  109 format(' Taille maximum du tableau de donnees:'/
     +        i7,' juges (ou especes)'/
     +        i7,' objets'/)
  209 format(' Maximum size of the input data table:'/
     +        i7,' judges (or species)'/
     +        i7,' objects'/)
  110 format(' Duree du calcul:',f10.2,' sec.'/)
  210 format(' Computation time:',f10.2,' sec.'/)
      end
      
      Subroutine WKendall(m,k,Table,T,R,jugemax,nmax,chisq,W,smrsq,iva,
     +                    ities,idebug)
      Real*8 Table(jugemax,nmax),R(nmax),denom,chisq,W,smrsq,T
C
C Ce sous-programme calcule le khi-carre de Friedman ainsi que le W de Kendall.
C Le coefficient de concordance (W) de Kendall mesure la variance entre 
C les sommes de rangs des differentes colonnes de la matrice 'Table'.
C La variance est faible lorsqu'il y a accord entre les lignes; elle augmente 
C avec l'augmentation du desaccord entre elles, soit entre les matrices D.
C W est borne dans l'intervalle [0, 1]: 0 = desaccord complet, 1 = accord maximum.
C Chi-carre est la statistique (pivotale) a tester.
C
      dflk=dfloat(k)
      dflm=dfloat(m)
      do 10 j=1,k
      R(j)=0.0
      do 10 i=1,m
   10 R(j)=R(j)+Table(i,j)
C Calcul des statistiques khi-carre de Friedman et W de Kendall avec correction 
C pour donnees liees (Siegel 1956: 234; Siegel & Castellan 1988: 266).
      smrsq=0.0
      do 12 j=1,k
   12 smrsq=smrsq+R(j)*R(j)
      goto (20,30) iva
   20    goto (22,24) ities
C Avec correction pour valeurs liees
   22      denom=dflm*dflm*dflk*(dflk+1.0)*(dflk-1.0) - dflm*T
           W=(12.0*smrsq-3.0*dflm*dflm*dflk*(dflk+1.0)*(dflk+1.0))/denom
           chisq=dflm*(dflk-1.0)*W
C           write(*,*) 'T,denom,smrsq,W,chisq',T,denom,smrsq,W,chisq
           return
C Sans correction pour valeurs liees
   24       chisq=(12.0*smrsq/dfloat(m*k*(k+1))) - dfloat(3*m*(k+1))
            W=chisq/dfloat(m*(k-1))
C            write(*,*) 'T,smrsq,W,chisq',T,smrsq,W,chisq
   30 return
      end
      
      Subroutine Spear(n,m,nmax,jugemax,Table,SpearR,novar,Result,
     +                 idebug)
      Integer novar(jugemax)
      Real*8 Table(jugemax,nmax),SpearR(jugemax,jugemax),
     +       Result(jugemax,7)
      Real*8 dfln,dflnm1,temp
C
C Calcul des degres de liberte
      dfln=dfloat(n)
      dflnm1=dfloat(n-1)
C
C Centrage et reduction de chaque variable (liste de rangs) de "Table"
C Attention: les variables (juges) forment les LIGNES de "Table"
      call Standard(n,m,nmax,jugemax,Table,novar,dfln,dflnm1)
C
C      if(idebug.eq.1) then
C         write(*,100)
C         do i=1,m
C            write(*,102) (Table(i,j), j=1,n)
C            enddo
C         endif
C
      do i=1,m
         SpearR(i,i)=1.0
         enddo
C Calcul des correlations (triangle superieur d'abord)
      do i=1,(m-1)
         do ii=(i+1),m
            if((novar(i).eq.0).or.(novar(ii).eq.0)) then
               SpearR(i,ii)=0.0
               SpearR(ii,i)=0.0
               else
               temp=0.0
               do j=1,n
                  temp=temp+Table(i,j)*Table(ii,j)
                  enddo
               temp=temp/dflnm1
               SpearR(i,ii)=temp
               SpearR(ii,i)=temp
               endif
            enddo
         enddo
C Calculer les statistiques R-bar (column 1 of 'Results')
      do i=1,m
         temp=0.0
         do ii=1,m
            temp=temp+SpearR(i,ii)
            enddo
         Result(i,2)=(temp-1.0)/dfloat(m-1)
         enddo
C Debug?
      if(idebug.eq.1) then
         write(*,101)
         do i=1,m
            write(*,102) (SpearR(i,ii), ii=1,m)
            enddo
         write(*,103)
         do i=1,m
            write(*,102) Result(i,2)
            enddo
         endif
C
      return
  100 format(/' Matrice des rangs centres reduits'/)
  101 format(/' Matrice des correlations de Spearman'/)
  102 format(100f10.5)
  103 format(/' Vecteur des statistiques R-bar'/)
      end

      Subroutine Standard(n,m,nmax,jugemax,X,novar,dfln,dflnm1)
      Integer novar(jugemax)
      Real*8 X(jugemax,nmax),sx,sx2,xbar,ety,dfln,dflnm1
C Centrage et reduction de chaque variable (ligne) de la matrice X.
      do 20 i=1,m
      sx=0.0
      sx2=0.0
      do 10 j=1,n
      sx=sx+X(i,j)
   10 sx2=sx2+X(i,j)*X(i,j)
      xbar=sx/dfln
      ety=(sx2-((sx**2)/dfln))/dflnm1
      ety=dsqrt(ety)
C
      if(ety.ne.0.0) then
         do j=1,n
            X(i,j)=(X(i,j)-xbar)/ety
            enddo
         novar(i)=1
         else
         do j=1,n
            X(i,j)=0.0
            enddo         
         novar(i)=0
         endif
   20 continue
      return
      end
      
      Subroutine Concord(n,m,k,Mat,Table,R,nmax,jugemax,langue,nperm,
     +  iordre,liste,data,rang,SpearR,vec,Result,buffer,number,novar,
     +  ities,idebug)
      Integer iordre(nmax),liste(nmax),novar(jugemax),number(jugemax)
      Real*8 Mat(jugemax,nmax),Table(jugemax,nmax),R(nmax),
     +       data(nmax),rang(nmax),SpearR(jugemax,jugemax),
     +       vec(nmax),Result(jugemax,7),buffer(nmax)
      Real*8 T,chisq,chisqper,W,Wper,probper,smrsq,smrsqper,temp
C
C2345678901234567890123456789012345678901234567890123456789012345678901234567890
C
C  Calcul et test de signification du coefficient de concordance W --
C
C  1. A tour de role, copier une ligne de 'Table' dans le vecteur 'data'.
C  2. Trier 'data' et le transformer en rangs.
C  3. Transcrire les donnees transformees en rangs dans 'Table'.
C  4. Transcrire les donnees en rangs dans 'Mat' qui ne sera plus modifie.
C  5. Calculer le khi-carre et le coefficient de concordance (W) de Kendall.
C  6. Permuter tous les juges et les recrire dans 'Table'.
C     Les objets sont les elements permutables.
C  7. Calculer W* sous permutation.
C  => Repeter les etapes 6 et 7 un grand nombre de fois.
C  8. Calculer la probabilite permutationnelle associee a W.
C
      T=0.0
      iva=1
C Etapes 1 a 4.
      do 10 ii=1,m
      do 2 j=1,k
    2 data(j)=Table(ii,j)
      call Tri(k,nmax,liste,data,rang,T)
      do 4 j=1,k
      Mat(ii,j)=data(j)
    4 Table(ii,j)=data(j)
   10 continue
C  5. Calculer le khi-carre et le coefficient de concordance (W) de Kendall.
      Call WKendall(m,k,Table,T,R,jugemax,nmax,chisq,W,smrsq,iva,
     +              ities,idebug)
      nu=k-1
      write(7,200)
      write(7,*)
      if(langue.eq.1) then
         if(ities.eq.1) write(7,101) chisq,nu,W
         if(ities.eq.2) write(7,106) chisq,nu,W
         endif
      if(langue.eq.2) then
         if(ities.eq.1) write(7,201) chisq,nu,W
         if(ities.eq.2) write(7,206) chisq,nu,W
         endif
C Preparation en vue des permutations
      do 12 i=1,n
   12 iordre(i)=i
      iseed=0
      do 13 i=1,100
   13 turn=rand(iseed)
C
C Test global: on permute tous les juges, sauf le dernier * * * * * * * * * * *
      iget=1
C Debut de la boucle de permutation - - - - - - - - - - - - - - - - - - - - - -
      do 30 iper=1,nperm
      iva=2
C
C  6. Permuter les juges (sauf le dernier) et les recrire dans 'Table'.
      do 20 ii=1,m-1
      call Permute(iseed,n,nmax,iordre)
C      if(idebug.eq.1) then
C         write(*,301) (iordre(i), j=1,k)
C         do 16 i=1,m*n
C   16    write(*,302) (Mat(i,j), j=1,n)
C         endif
  301 format(20i4)
  302 format(20f6.3)
      do 14 jj=1,n
   14 Table(ii,jj)=Mat(ii,iordre(jj))
   20 continue
C
C  7. Calculer W sous permutation.
      Call WKendall(m,k,Table,T,R,jugemax,nmax,chisqper,Wper,smrsqper,
     +   iva,ities,idebug)
      if(smrsqper.ge.smrsq) iget=iget+1
C
   30 continue
C Fin de la boucle de permutation - - - - - - - - - - - - - - - - - - - - - - -
C
C  8. Calculer la probabilite permutationnelle associee a W.
      probper=dfloat(iget)/dfloat(nperm+1)
      if(langue.eq.1) then
         write(7,102)
         write(7,103) nperm,probper
         else
         write(7,202)
         write(7,203) nperm,probper
         endif
      write(7,200)
      write(7,*)
C
C Calcul des statistiques R-bar (first column of 'Result'):
C moyenne des correlations de Spearman du juge "i" avec tous les autres.
C "novar" est un vecteur binaire indiquant, par "0", les juges invariants.
C     Recopier d'abord tous les juges dans 'Table'
      do iii=1,m
         do jj=1,n
            Table(iii,jj)=Mat(iii,jj)
            enddo
         Result(iii,1)=dfloat(iii)
         enddo
      call Spear(n,m,nmax,jugemax,Table,SpearR,novar,Result,idebug)
C
C Test particulier pour chaque juge * * * * * * * * * * * * * * * * * * * * * *
      do 50 ii=1,m
      iget=1
C     Recopier d'abord tous les juge dans 'Table' sans les permuter
      do iii=1,m
         do jj=1,n
            Table(iii,jj)=Mat(iii,jj)
            enddo
         enddo
C Debut de la boucle de permutation - - - - - - - - - - - - - - - - - - - - - -
      do 40 iper=1,nperm
      iva=2
C
C  6. Permuter le juge ii et le recrire dans 'Table'.
      call Permute(iseed,n,nmax,iordre)
      do 38 jj=1,n
   38 Table(ii,jj)=Mat(ii,iordre(jj))
C
C  7. Calculer W sous permutation.
      Call WKendall(m,k,Table,T,R,jugemax,nmax,chisqper,Wper,smrsqper,
     +   iva,ities,idebug)
      if(smrsqper.ge.smrsq) iget=iget+1
C
   40 continue
C Fin de la boucle de permutation - - - - - - - - - - - - - - - - - - - - - - -
C
C  8. Calculer la probabilite permutationnelle associee a W.
      Result(ii,3)=( (dfloat(m-1)*Result(ii,2))+1.0 )/dfloat(m)
      probper=dfloat(iget)/dfloat(nperm+1)
      Result(ii,4)=probper
   50 continue 
C Fin des tests particuliers  * * * * * * * * * * * * * * * * * * * * * * * * *
C
C  9. Compute adjusted p-values (Bonferroni, Holm)
      if(langue.eq.1) then
         write(7,104)
         else
         write(7,204)
         endif
      Call AdjustP(m,jugemax,vec,Result,buffer,number,idebug)
C
C  Print results
      note=0
      do ii=1,m
         iii=Result(ii,1)
         if(novar(ii).eq.1) then
            write(7,105) iii,(Result(ii,j), j=2,5), Result(ii,7)
            else
            write(7,107) iii,(Result(ii,j), j=2,5), Result(ii,7)
            note=1
            endif
         enddo
C
      write(7,200)
      if(note.eq.1) then
         if(langue.eq.1) then
            write(7,108)
            else
            write(7,208)
            endif
         endif
C
      return
  200 format(
     +  ' ------------------------------------------------------------')
  101 format(' Khi-carre de Friedman =',f10.5,'   nu =',i5/
     +       ' W de Kendall          =',f10.5,
     +       '   correction pour ex-aequo'/)
  201 format(' Friedman''s Chi-square =',f10.5,'   nu =',i5/
     +       ' Kendall''s W           =',f10.5,
     +       '   with correction for ties'/)
  106 format(' Khi-carre de Friedman =',f10.5,'   nu =',i5/
     +       ' W de Kendall          =',f10.5,
     +       '   sans correction pour ex-aequo'/)
  206 format(' Friedman''s Chi-square =',f10.5,'   nu =',i5/
     +       ' Kendall''s W           =',f10.5,
     +       '   without correction for ties'/)
  102 format(' Test global. H0: Independance des juges.'/
     +   ' Tous les juges sont permutes, et ce de facon independante.'/)
  202 format(' Global test. H0: Independence of all judges.'/
     +       ' All judges are independently permuted.'/)
  103 format(' Prob(khi-carre,',i6,' perm.) =',f8.5/)
  203 format(' Prob(chi-square,',i6,' perm.) =',f8.5/)
  104 format(/' Test a posteriori de chaque juge.'/
     +       ' Resultats presentes en ordre decroissant de Rbar.'/
     +       ' H0: Independance de ce juge. Seul ce juge est permute.'//
     +      '                                    Probabilite corrigee'/
     +      ' Juge    Rbar(j)     W(j)     Prob  Bonferroni      Holm'/)
C             1234xx12345678901234567890123456789012345678901234567890     
  204 format(/' A posteriori test for each judge.'/
     + ' Results are presented in order of decreasing values of Rbar.'/
     + ' H0: Independence of this judge. This judge only is permuted.'//
     +      '                                    Adjusted probability'/
     +      ' Judge   Rbar(j)     W(j)     Prob  Bonferroni      Holm'/)
  105 format(i4,2x,5f10.5/)
  107 format(i4,2x,5f10.5,' #'/)
  108 format(' # Ce juge a une variance nulle')
  208 format(' # This judge has a null variance')
      end
      
      Subroutine Lecture(n,m,k,Mat,Table,nmax,jugemax,langue)
      Real*8 Mat(jugemax,nmax),Table(jugemax,nmax)
C      String nom
      Character*79 nom
C Lecture des donnees  
      if(langue.eq.1) then
         write(*,*)'Combien de juges et d''objets?'
         else
         write(*,*)'How many judges and objects?'
         endif
      read(*,*) m,n
      if(n.gt.nmax) then
         if(langue.eq.1) 
     +   write(*,*) 'Trop d''objets. Recompiler le programme.'
         if(langue.eq.2) 
     +   write(*,*) 'Too many objects. Recompile the program.'
         Stop 2
         endif
      if(m.gt.jugemax) then
         if(langue.eq.1) 
     +   write(*,*) 'Trop de juges. Recompiler le programme.'
         if(langue.eq.2) 
     +   write(*,*) 'Too many judges. Recompile the program.'
         Stop 3
         endif
      k=n
      write(*,*)
      if(langue.eq.1) then
         write(*,*) '(1) Les juges sont les lignes du fichier d''entree'
       write(*,*) '(2) Les juges sont les colonnes du fichier d''entree'
         else
         write(*,*) '(1) Judges are the rows of the input data file'
         write(*,*) '(2) Judges are the columns of the input data file'
         endif
       read(*,*) isens
C Fichier de donnees
      write(*,*)
      if(langue.eq.1) write(*,*) 'Nom du fichier de donnees?'
      if(langue.eq.2) write(*,*) 'Name of the input data file?'
C Lecture pour g77 (2 lignes)
      read(*,*) nom
      open(10,file=nom,status='OLD')
C Lecture pour LS Fortran (2 lignes)
C      open(10,file=*,status='OLD')
C      inquire(unit=10,name=nom)
C
      if(langue.eq.1) then
         write(*,*) 'Fichier de donnees: ', nom
         write(7,*) 'Fichier de donnees: ', nom
         else
         write(*,*) 'Input data file: ', nom
         write(7,*) 'Input data file: ', nom
         endif
C
      if(isens.eq.1) then
         do 6 i=1,m
    6    read(10,*) (Mat(i,j), j=1,n)
         else
         do 8 j=1,n
    8    read(10,*) (Mat(i,j), i=1,m)
         endif
      close(10)
C Transcrire les juges dans Table
      write(7,*)
      do 24 i=1,m
      do 22 j=1,n
   22 Table(i,j)=Mat(i,j)
   24 continue
C
      return
      end
      
      Subroutine AdjustP(m,jugemax,vec,Result,buffer,number,idebug)
      Integer number(jugemax)
      Real*8 vec(jugemax),Result(jugemax,7),buffer(jugemax)
C This subroutine computes various forms of adjusted probability values for
C multiple testing.
C
C Result = initially: (1) JudgeNo, (2) Rbar, (3) W(j), (4) Prob
C          added at end of procedure: (5) Bonferroni, (6) adj.p, (7) adj.Holm
C 
C Sort 'Results' by ascending values of Prob (found in col. 4 of 'Result')
      do i=1,m
         vec(i)=Result(i,4)
         enddo
      call SortPL(m,jugemax,7,vec,Result,buffer,number,1,idebug)
C *** Debug
      if(idebug.gt.0) then
         write(7,*)
         write(7,*) 'First print in AdjustP'
         do ii=1,m
            iii=Result(ii,1)
            write(7,105) iii,(Result(ii,j), j=2,5), Result(ii,7)
            enddo
         endif
C
C (5) Bonferroni, (6) Adjusted prob., (7) Holm's adjustment
      do i=1,m
         Result(i,5)=Result(i,4)*float(m)
         Result(i,6)=Result(i,4)*float(m-i+1)
         Result(i,7)=Result(i,6)
         enddo
      do i=2,m
         if(Result(i,7).lt.Result(i-1,7)) Result(i,7)=Result(i-1,7)
         enddo
C Sort 'Results' by descending values of R-bar (found in col. 2 of 'Result')
      do i=1,m
         vec(i)=Result(i,2)
         enddo
C
      call SortPL(m,jugemax,7,vec,Result,buffer,number,2,idebug)
C *** Debug
      if(idebug.gt.0) then
         write(7,*)
         write(7,*) 'Second print in AdjustP'
         do ii=1,m
            iii=Result(ii,1)
            write(7,105) iii,(Result(ii,j), j=2,5), Result(ii,7)
            enddo
         write(7,*)
         endif
C
      return
  105 format(i4,2x,5f10.5)
      end

      Subroutine SortPL(n,nmax,k,vec,mat,buffer,number,iopt,idebug)
      Integer number(nmax)
      Real*8 vec(nmax),mat(nmax,k),buffer(nmax),temp
C Put the values in 'vec' and corresponding rows of 'mat' in
C    (iopt=1) ascending order 
C    (iopt=2) descending order 
C using a bubble-up sorting strategy.
C
C Phase 1: sort 'vec' and, with it, the vector of integers 'number'
      do i=1,n
         number(i)=i
         enddo
      do ii=2,n
         temp=vec(ii)
         nn=number(ii)
         do i=ii-1,1,-1
            goto (2,4) iopt
    2       if ((vec(i)-temp).lt.0.00000001) goto 10
            goto 6
    4       if ((vec(i)-temp).gt.0.00000001) goto 10
    6       vec(i+1)=vec(i)
            number(i+1)=number(i)
            enddo
         i=0
   10    vec(i+1)=temp
         number(i+1)=nn
      if((idebug.gt.0).and.(n.le.20)) then
         write(7,*) 'n =',n
         write(7,100) (number(i), i=1,n)
         write(7,101) (vec(i), i=1,n)
         endif
         enddo
C
C Phase 2: Sort rows of 'mat' according to the new order of 'number'
      do j=1,k
         do i=1,n
            buffer(i)=mat(i,j)
            enddo
         do i=1,n
            mat(i,j)=buffer(number(i))
            enddo
         enddo
C
      return
  100 format(20i3)
  101 format(20f5.2)
      end

      Subroutine Permute (iseed,n,nmax,iordre)
C This subroutine permutes the first 'n' values of vector 'iordre' at random
C in an equiprobable way. This property has been checked through intensive 
C simulations.
      Integer iseed,n,i,itemp,km1,mm
      Integer iordre(nmax)
      mm=n
      km1=n-1
      do 10 i=1,km1
    8    j = 1 + rand(iseed)*mm
         if(j.gt.mm) goto 8
         itemp = iordre(mm)
         iordre(mm) = iordre(j)
         iordre(j) = itemp
         mm=mm-1
   10 continue
      return
      end

      Subroutine Tri(k,nmax,liste,data,rang,T)
      Integer liste(nmax)
      Real*8 data(nmax),rang(nmax),T,temp
C Tri: on remplace les donnees par leur rang en tenant compte des ex-aequo.
C T = facteur de correction pour donnees ex aequo dans le calcul de W.
C k = nombre d'objets
C rang(i) = rang de l'objet i; rang le plus eleve, lorsque donnees liees
C liste(icount) = nombre de valeurs de rang 'icount'
      do 20 i=1,k
   20 liste(i)=0
      do 24 i=1,k
      icount=0
      do 22 j=1,k
      if(data(j).le.data(i)) icount=icount+1
   22 continue
      rang(i)=dfloat(icount)
      liste(icount)=liste(icount)+1
   24 continue
C Les 3 lignes suivantes sont utilisees pour la correction pour valeurs liees:
      do 26 i=1,k
      temp=dfloat(liste(i))
   26 T=T+temp*(temp+1.0)*(temp-1.0)
C      write(*,*) 'T (in Tri) =',T
C      write(*,*) 'rang  =',(rang(i), i=1,k)
C      write(*,*) 'liste =',(liste(i), i=1,k)
C On recalcule les rangs en tenant compte des donnees liees (valeur moyenne). 
C Puis, les rangs sont recopies dans le vecteur 'data'.
      do 30 i=1,k
      irang=rang(i)
      no=liste(irang)
      if(no.eq.1) then
         data(i)=rang(i)
         else
         itemp=0.0
         do 28 j=1,no
   28    itemp=itemp+irang-j+1
         data(i)=dfloat(itemp)/dfloat(no)
         endif
   30 continue
C      write(*,*) 'data  =',(data(i), i=1,k)
      return
      end
